/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.endimator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.blueprint.common.codec.ErrorableOptionalFieldCodec;
import com.teamabnormals.blueprint.core.endimator.interpolation.EndimationEasers;
import com.teamabnormals.blueprint.core.endimator.interpolation.EndimationInterpolator;
import com.teamabnormals.blueprint.core.endimator.interpolation.InterpolationType;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.Util;

public final class EndimationKeyframe
implements Comparable<EndimationKeyframe> {
    public static final EndimationInterpolator LINEAR = new EndimationInterpolator(InterpolationType.LINEAR, EndimationEasers.LINEAR);
    public static final EndimationInterpolator CATMULL_ROM = new EndimationInterpolator(InterpolationType.CATMULL_ROM, EndimationEasers.LINEAR);
    private static final Either<Transform, Pair<Transform, Transform>> DEFAULT_TRANSFORM = Either.left((Object)new Transform(() -> Float.valueOf(0.0f), () -> Float.valueOf(0.0f), () -> Float.valueOf(0.0f)));
    private static final Codec<Vector3f> VECTOR_CODEC = Codec.FLOAT.listOf().comapFlatMap(floats -> Util.m_143795_((List)floats, (int)3).map(vec -> new Vector3f(((Float)vec.get(0)).floatValue(), ((Float)vec.get(1)).floatValue(), ((Float)vec.get(2)).floatValue())), vec -> Arrays.asList(Float.valueOf(vec.m_122239_()), Float.valueOf(vec.m_122260_()), Float.valueOf(vec.m_122269_()))).stable();
    public static final Codec<Transform> PRE_POST_CODEC = VECTOR_CODEC.xmap(vec -> new Transform(() -> ((Vector3f)vec).m_122239_(), () -> ((Vector3f)vec).m_122260_(), () -> ((Vector3f)vec).m_122269_()), expression -> new Vector3f(expression.x.get().floatValue(), expression.y.get().floatValue(), expression.z.get().floatValue()));
    public static final Codec<Pair<Transform, Transform>> PRE_AND_POST_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PRE_POST_CODEC.fieldOf("pre").forGetter(Pair::getFirst), (App)PRE_POST_CODEC.fieldOf("post").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::new));
    public static final Codec<EndimationKeyframe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("time").forGetter(keyframe -> Float.valueOf(keyframe.time)), (App)Codec.either(PRE_POST_CODEC, PRE_AND_POST_CODEC).optionalFieldOf("transform", DEFAULT_TRANSFORM).forGetter(keyframe -> {
        Transform pre = new Transform(keyframe.preX, keyframe.preY, keyframe.preZ);
        Transform post = new Transform(keyframe.postX, keyframe.postY, keyframe.postZ);
        return pre.equals(post) ? Either.left((Object)post) : Either.right((Object)Pair.of((Object)pre, (Object)post));
    }), (App)ErrorableOptionalFieldCodec.errorableOptional("interpolation", EndimationInterpolator.CODEC, LINEAR).forGetter(keyframe -> keyframe.interpolator)).apply((Applicative)instance, (time, singleTransformOrPreAndPost, interpolator) -> {
        Optional left = singleTransformOrPreAndPost.left();
        if (left.isPresent()) {
            return new EndimationKeyframe(time.floatValue(), (Transform)left.get(), (EndimationInterpolator)interpolator);
        }
        Pair preAndPost = (Pair)singleTransformOrPreAndPost.right().get();
        Transform pre = (Transform)preAndPost.getFirst();
        Transform post = (Transform)preAndPost.getSecond();
        return new EndimationKeyframe(time.floatValue(), pre.x, pre.y, pre.z, post.x, post.y, post.z, (EndimationInterpolator)interpolator);
    }));
    public final float time;
    public final Supplier<Float> preX;
    public final Supplier<Float> preY;
    public final Supplier<Float> preZ;
    public final Supplier<Float> postX;
    public final Supplier<Float> postY;
    public final Supplier<Float> postZ;
    public final EndimationInterpolator interpolator;

    public EndimationKeyframe(float time, Supplier<Float> preX, Supplier<Float> preY, Supplier<Float> preZ, Supplier<Float> postX, Supplier<Float> postY, Supplier<Float> postZ, EndimationInterpolator interpolator) {
        this.time = time;
        this.preX = preX;
        this.preY = preY;
        this.preZ = preZ;
        this.postX = postX;
        this.postY = postY;
        this.postZ = postZ;
        this.interpolator = interpolator;
    }

    public EndimationKeyframe(float time, Transform transform, EndimationInterpolator interpolator) {
        this.time = time;
        this.postX = transform.x;
        this.preX = this.postX;
        this.postY = transform.y;
        this.preY = this.postY;
        this.postZ = transform.z;
        this.preZ = this.postZ;
        this.interpolator = interpolator;
    }

    public void apply(Vector3f vec3, EndimationKeyframe[] keyframes, EndimationKeyframe from, EndimationKeyframe to, int index, int keyframeCount, float progress) {
        this.interpolator.apply(vec3, keyframes, from, to, index, keyframeCount, progress);
    }

    @Override
    public int compareTo(EndimationKeyframe keyframe) {
        return Float.compare(this.time, keyframe.time);
    }

    public record Transform(Supplier<Float> x, Supplier<Float> y, Supplier<Float> z) {
    }
}

